<?php
namespace IssetBV\MijnIssetAuthBundle\Service\XAuth;

use GuzzleHttp\Client as HttpClient;
use IssetBV\MijnIssetAuthBundle\Service\ClientInterface;
use LogicException;
use Symfony\Component\HttpFoundation\Request;

class Client implements ClientInterface
{

    /**
     * @var HttpClient
     */
    private $client;

    public function __construct($url)
    {
        $this->client = new HttpClient([
            'base_url' => rtrim($url, '/') . '/'
        ]);
    }

    public function loginRequest(Request $request)
    {
        $consumerKey = $request->request->get("consumer_key");
        $time = $request->request->get("time");
        $hash = $request->request->get("hash");
        $hasher = $request->request->get("hasher", null);
        if ($consumerKey === null || $time === null || $hash === null) {
            throw new LogicException("Missing parameters");
        }
        return $this->login($consumerKey, $time, $hash, $hasher);
    }

    public function login($consumerKey, $time, $hash, $hasher = null)
    {
        $loginData = $this->client->post('api/xauth/login', [
            'body' => [
                'consumer_key' => $consumerKey,
                'time' => $time,
                'hash' => $hash,
                'hasher' => $hasher
            ]
        ]);
        return json_decode($loginData->getBody()->getContents())->token;
    }

    public function getAccount($token)
    {
        $loginData = $this->client->get('api/xauth/account', [
            'headers' => [
                'x-auth-token' => $token
            ]
        ])
            ->getBody()
            ->getContents();
        return json_decode($loginData);
    }
}