<?php
namespace IssetBV\MijnIssetAuthBundle\Security\XAuth;

use Exception;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Exception\AuthenticationException;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use Symfony\Component\Security\Http\Authentication\SimplePreAuthenticatorInterface;

class XAuthAuthenticator implements SimplePreAuthenticatorInterface
{

    private $tokenName;

    public function __construct($tokenName)
    {
        $this->tokenName = $tokenName;
    }

    /* (non-PHPdoc)
     * @see \Symfony\Component\Security\Core\Authentication\SimplePreAuthenticatorInterface::createToken()
     */
    public function createToken(Request $request, $providerKey)
    {
        $apiKey = $request->headers->get($this->tokenName);
        if (! $apiKey) {
            throw new HttpException(403, 'No API key found');
        }
        
        return new XAuthToken('anon.', $apiKey, $providerKey);
    }

    public function authenticateToken(TokenInterface $token, UserProviderInterface $userProvider, $providerKey)
    {
        $apiKey = $token->getCredentials();
        try {
            $username = $userProvider->getUsernameForApiKey($apiKey);
            if (! $username) {
                throw new AuthenticationException(sprintf('API Key "%s" does not exist.', $apiKey));
            }
            $user = $userProvider->loadUserByUsername($username);
            
            $return = new XAuthToken($user, $apiKey, $providerKey, $user->getRoles());
            $return->setAuthenticated(true);
            return $return;
        } catch (Exception $e) {
            throw new HttpException(403, 'API key invalid');
        }
    }

    public function supportsToken(TokenInterface $token, $providerKey)
    {
        return $token instanceof XAuthToken && $token->getProviderKey() === $providerKey;
    }
}