<?php

namespace IssetBV\MijnIssetAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use IssetBV\MijnIssetAuthBundle\Security\OAuth\OAuthToken;


/**
 * Class DeviceController.
 *
 * @author Bart Malestein <bart@isset.nl>
 */
class DeviceController extends Controller
{
    /**
     * @param Request $request
     * @return Response
     */
    public function linkAccountToDeviceAction(Request $request)
    {
        $client = $this->get('isset_bv_mijn_isset.oauth.client');

        /** @var OAuthToken $token */
        $token = $this->container->get('security.token_storage')->getToken();

        $response = $client->linkAccountToDevice(
            $token->getUsername(),
            $request->get('code')
        );

        return new Response(null, $response->getStatusCode());
    }

    /**
     * @return Response
     */
    public function fetchDeviceCodeAction()
    {
        $client = $this->get('isset_bv_mijn_isset.oauth.client');

        $response = $client->fetchDeviceCode();

        return new JsonResponse($response->getBody(true), $response->getStatusCode());
    }

    /**
     * @param Request $request
     * @return JsonResponse
     */
    public function fetchTokenForDeviceCodeAction(Request $request)
    {
        $client = $this->get('isset_bv_mijn_isset.oauth.client');

        $response = $client->fetchTokenForDeviceCode($request->get('code'));

        return new JsonResponse($response->getBody(true), $response->getStatusCode());
    }
}