<?php

namespace IssetBV\MijnIssetAuthBundle\Exception;

use Exception;

/**
 * Class PlatformClientException
 * @author Bart Malestein <bart@isset.nl>
 */
class PlatformClientException extends Exception
{

    /**
     * @var int
     */
    protected $httpStatusCode;

    /**
     * @param string $message
     * @param int $httpStatusCode
     * @param Exception $previous
     */
    public function __construct($message = "", $httpStatusCode = 0, Exception $previous = null)
    {
        parent::__construct($message, 0, $previous);
        $this->httpStatusCode = $httpStatusCode;
    }

    /**
     * @return int
     */
    public function getHttpStatusCode()
    {
        return $this->httpStatusCode;
    }

}