<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth\Login;

use IssetBV\MijnIssetAuthBundle\Service\OAuth\Login\LoginTokenGenerator;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;

/**
 * Class Login
 * @package IssetBV\MijnIssetAuthBundle\Service\OAuth\Login
 * @author <felix@isset.nl>
 */
class Login
{

    /**
     *
     * @var \IssetBV\MijnIssetAuthBundle\Service\OAuth\Login\LoginTokenGenerator
     */
    private $tokenGenerator;

    /**
     * @var Client
     */
    private $client;

    /**
     * @var
     */
    private $publicKey;

    /**
     * @var
     */
    private $privateKey;

    /**
     * @param LoginTokenGenerator $tokenGenerator
     * @param Client $client
     * @param $publicKey
     * @param $privateKey
     */
    public function __construct(LoginTokenGenerator $tokenGenerator, Client $client, $publicKey, $privateKey)
    {
        $this->tokenGenerator = $tokenGenerator;
        $this->client = $client;
        $this->publicKey = $publicKey;
        $this->privateKey = $privateKey;
    }

    /**
     * @param $returnUrl
     * @return string
     */
    public function getRedirectUrl($returnUrl)
    {
        $token = $this->tokenGenerator->generate($this->publicKey, $this->privateKey);
        return $this->client->loginUrl($token, 1, $returnUrl);
    }
}