<?php
namespace IssetBV\MijnIssetAuthBundle\Service\Platform;

use GuzzleHttp\Client as HttpClient;
use IssetBV\MijnIssetAuthBundle\Presenter\PaymentsPresenter;
use GuzzleHttp\Stream\Stream;
use IssetBV\MijnIssetAuthBundle\Response\GuzzleResponse;
use GuzzleHttp\Exception\ClientException;

class Client
{

    /**
     * @var HttpClient
     */
    private $client;

    private $token;

    public function __construct($url, $token)
    {
        $this->token = $token;
        $this->client = new HttpClient([
            'base_url' => rtrim($url, '/') . '/'
        ]);
    }

    public function sendPayments($accountUuid, $divisionUuid, array $data)
    {
        $request = $this->client->createRequest('POST', 'api/platform/pay', array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid
            )
        ));
        
        $presenter = new PaymentsPresenter();
        $presenter->setPayments($data);
        $json = $presenter->getJson();
        
        $request->setBody(Stream::factory($json));
        try {
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }

    /**
     * @param $token
     * @return GuzzleResponse
     */
    public function getRemotes($accountUuid, $divisionUuid)
    {
        $request = $this->client->createRequest('GET', 'api/platform/account/remotes', array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid
            )
        ));
        
        try {
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }

    /**
     * @param $token
     * @param $identifier
     * @return GuzzleResponse
     */
    public function getRemoteDetails($accountUuid, $divisionUuid, $identifier)
    {
        $request = $this->client->createRequest('GET', 'api/platform/account/remotes/' . $identifier, array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid,
                'x-division-uuid' => $divisionUuid
            )
        ));
        
        try {
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }

    /**
     * @param $token
     * @param $identifier
     * @return GuzzleResponse
     */
    public function deleteRemote($accountUuid, $identifier)
    {
        $request = $this->client->createRequest('DELETE', 'api/platform/account/remotes/' . $identifier, array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid
            )
        ));
        
        try {
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }

    /**
     * @param $token
     * @param array $remote
     * @return GuzzleResponse
     */
    public function createRemote($accountUuid, array $remote)
    {
        $request = $this->client->createRequest('POST', 'api/platform/account/remotes', array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid
            )
        ));
        $request->setBody(Stream::factory(json_encode($remote)));
        try {
            
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }

    /**
     * @param $token
     * @param $identifier
     * @param $remote
     * @return GuzzleResponse
     */
    public function updateRemote($accountUuid, $identifier, $remote)
    {
        $request = $this->client->createRequest('POST', 'api/platform/account/remotes/' . $identifier, array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'x-account-uuid' => $accountUuid
            )
        ));
        
        $request->setBody(Stream::factory(json_encode($remote)));
        try {
            
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }
}