<?php
namespace IssetBV\MijnIssetAuthBundle\Controller;

use Exception;
use GuzzleHttp\Exception\ClientException;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Symfony\Component\HttpFoundation\JsonResponse;

class XAuthController extends Controller
{

    public function loginAction(Request $request)
    {
        try {
            $data = $this->get('isset_bv_mijn_isset.xauth.client')->loginRequest($request);
            return new JsonResponse($data);
        } catch (ClientException $e) {
            $data = json_decode($e->getResponse()
                ->getBody()
                ->getContents());
            return new JsonResponse($data, $e->getResponse()->getStatusCode());
        } catch (Exception $e) {
            throw new HttpException(400, $e->getMessage(), $e);
        }
    }
}