<?php
namespace IssetBV\MijnIssetAuthBundle\Presenter;
use Exception;

/**
 * Class Payments
 * @author Bart Malestein <bart@isset.nl>
 */
class PaymentsPresenter
{

    /**
     * @var array
     */
    private $payments = array();

    /**
     * @param array $payments
     * @throws \Exception
     */
    public function setPayments(array $payments){
        foreach($payments as $payment){
            if(!is_array($payment)){

                throw new Exception('Set payments is expecting a two-dimensional array');
            }

        }

        $this->payments = $payments;
    }

    /**
     * @param array $payment
     */
    public function addPayment(array $payment)
    {
        $this->payments[] = $payment;
    }

    /**
     * @return string
     * @throws Exception
     */
    public function getJson(){

        $data = array();
        $data['payments'] = $this->payments;

        $json = json_encode($data);

        if($json === null){

            throw new Exception('Unable to parse json');
        }

        return $json;

    }

}