<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth\Login;

use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;

/**
 * Class LoginTokenGenerator
 * @package IssetBV\MijnIssetAuthBundle\Service\OAuth\Login
 * @author <felix@isset.nl>
 */
class LoginTokenGenerator
{

    /**
     *
     * @var \Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface
     */
    private $encoder;

    /**
     *
     * @var \IssetBV\MijnIssetAuthBundle\Service\OAuth\Client
     */
    private $client;

    /**
     * @param EncoderFactoryInterface $encoderFactory
     * @param Client $client
     */
    public function __construct(EncoderFactoryInterface $encoderFactory, Client $client)
    {
        $this->encoder = $encoderFactory->getEncoder($this);
        $this->client = $client;
    }

    /**
     * @param $publicKey
     * @param $privateKey
     * @return mixed
     */
    public function generate($publicKey, $privateKey)
    {
        $time = time() . '_' . sha1(mt_rand(0, mt_getrandmax()) . microtime() . uniqid('_', true));
        $hash = $this->encoder->encodePassword($publicKey . $privateKey . $time, $time);
        return $this->client->getLoginToken($publicKey, $time, $hash);
    }
}