<?php
/**
 * Created by PhpStorm.
 * User: bart
 * Date: 30-3-15
 * Time: 16:23
 */

namespace IssetBV\MijnIssetAuthBundle\Presenter;

/**
 * Class RemotePresenter
 * @package IssetBV\MijnIssetAuthBundle\Presenter
 * @author Bart Malestein <bart@isset.nl>
 */
class RemotePresenter
{

    protected $name;

    protected $type;

    protected $authToken;

    protected $authAdditionToken;

    protected $location;

    /**
     * @param $data
     */
    function __construct($data)
    {
        $this->name = $data['name'];
        $this->type = $data['type'];
        $this->location = $data['location'];
        $this->authToken = isset($data['authToken']) ? $data['authToken'] : null;
        $this->authAdditionToken = isset($data['authAdditionToken']) ? $data['authAdditionToken'] : null;

    }

    /**
     * @return mixed
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return mixed
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * @return null
     */
    public function getAuthToken()
    {
        return $this->authToken;
    }

    /**
     * @return null
     */
    public function getAuthAdditionToken()
    {
        return $this->authAdditionToken;
    }

    /**
     * @return mixed
     */
    public function getLocation()
    {
        return $this->location;
    }



}