<?php
namespace IssetBV\MijnIssetAuthBundle\Security\Event;

use Symfony\Component\EventDispatcher\Event;
use IssetBV\MijnIssetAuthBundle\Security\AuthUser;

/**
 * Class LoadUserEvent
 * @package IssetBV\MijnIssetAuthBundle\Security\Event
 * @author <felix@isset.nl>
 */
class LoadUserEvent extends Event
{

    /**
     *
     */
    const EVENT = 'oauth.load.user';

    /**
     *
     * @var OAuthUser
     */
    private $authUser;

    /**
     * @param OAuthUser $oAuthUser
     */
    public function __construct(AuthUser $authUser)
    {
        $this->authUser = $authUser;
    }

    /**
     *
     * @return OAuthUser
     */
    public function getAuthUser()
    {
        return $this->authUser;
    }
}
