<?php

namespace IssetBV\MijnIssetAuthBundle\Controller;

use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;
use IssetBV\MijnIssetAuthBundle\Security\OAuth\OAuthToken;

/**
 * Class RemoteController
 * @package IssetBV\MijnIssetAuthBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class RemoteController extends Controller{

    /**
     * @return Response
     */
    public function indexAction(){

        /** @var Client $client */
        $client = $this->get('isset_bv_mijn_isset.oauth.client');

        /** @var OAuthToken $token */
        $token = $this->container->get('security.context')->getToken();

        $response = $client->getRemotes($token->getCredentials());
        $remotes = $response->getBody(true);

        return $this->render($this->container->getParameter('isset_bv_mijn_isset_auth.remotes.index'), ['remotes' => $remotes]);
    }

    /**
     * @param $id
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction($id){
        /** @var Client $client */
        $client = $this->get('isset_bv_mijn_isset.oauth.client');

        /** @var OAuthToken $token */
        $token = $this->container->get('security.context')->getToken();

        $response = $client->deleteRemote($token, $id);

        if($response->getStatusCode() === Response::HTTP_NO_CONTENT){
            $this->get('session')->getFlashBag()->add('success', 'Remote removed');
        }else{
            $this->get('session')->getFlashBag()->add('danger', 'Failed to remove remote');
        }

        return $this->redirect($this->generateUrl('isset_bv_mijn_isset_auth_remotes_index'));

    }

}