<?php
namespace IssetBV\MijnIssetAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

/**
 * Class LoginController
 * @package IssetBV\MijnIssetAuthBundle\Controller
 * @author <felix@isset.nl>
 */
class OAuthController extends Controller
{

    /**
     * @return RedirectResponse
     */
    public function loginAction()
    {
        $returnUrl = $this->generateUrl('isset_bv_mijn_isset_auth_callback', array(), UrlGeneratorInterface::ABSOLUTE_URL);
        $redirectUrl = $this->get('isset_bv_mijn_isset.oauth.login')->getRedirectUrl($returnUrl);

        return $this->redirect($redirectUrl);
    }

    /**
     * @param Request $request
     * @return RedirectResponse
     */
    public function logoutAction(Request $request)
    {
        $this->get('security.context')->setToken(null);
        $request->getSession()->invalidate();

        $returnUrl = $this->generateUrl('isset_bv_mijn_isset_auth_login', array(), UrlGeneratorInterface::ABSOLUTE_URL);

        $redirectUrl = $this->get('isset_bv_mijn_isset.oauth.login')->getLogoutUrl($returnUrl);
        return $this->redirect($redirectUrl);
    }

    /**
     * @param Request $request
     * @return RedirectResponse
     */
    public function callbackAction(Request $request)
    {
        if ($request->get('message', '') == 'success') {
            $route = $this->container->getParameter('isset_bv_mijn_isset.oauth.route_success');
        } else {
            $route = $this->container->getParameter('isset_bv_mijn_isset.oauth.route_failed');
        }
        
        return $this->redirect($this->generateUrl($route));
    }
}
