<?php
namespace IssetBV\MijnIssetAuthBundle\Service\Platform;

use GuzzleHttp\Client as HttpClient;
use IssetBV\MijnIssetAuthBundle\Presenter\PaymentsPresenter;
use GuzzleHttp\Stream\Stream;
use IssetBV\MijnIssetAuthBundle\Response\GuzzleResponse;
use GuzzleHttp\Exception\ClientException;

class Client
{

    /**
     * @var HttpClient
     */
    private $client;

    private $token;

    public function __construct($url, $token)
    {
        $this->token = $token;
        $this->client = new HttpClient([
            'base_url' => rtrim($url, '/') . '/'
        ]);
    }

    public function sendPayments($accountUuid, $divisionUuid, array $data)
    {
        $request = $this->client->createRequest('POST', 'api/platform/pay', array(
            'headers' => array(
                'x-my-platform' => $this->token,
                'account_uuid' => $accountUuid,
                'division_uuid' => $divisionUuid
            )
        ));
        
        
        $presenter = new PaymentsPresenter();
        $presenter->setPayments($data);
        $json = $presenter->getJson();
        
        $request->setBody(Stream::factory($json));
        try {
            $response = $this->client->send($request);
        } catch (ClientException $ex) {
            
            return new GuzzleResponse($ex->getResponse());
        }
        
        return new GuzzleResponse($response);
    }
}