<?php
namespace IssetBV\MijnIssetAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use DateTime;
use IssetBV\MijnIssetAuthBundle\Model\User;

/**
 * @ORM\MappedSuperclass
 */
class OAuthUser implements User
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var string 
     * @ORM\Column(name="account_uuid", type="string", nullable=false, unique=true)
     */
    protected $accountUuid;

    /**
     * @var string 
     * @ORM\Column(name="owner_uuid", type="string", nullable=false)
     */
    protected $ownerUuid;

    /**
     * @var string 
     * @ORM\Column(name="token", type="string", nullable=false, unique=true)
     */
    protected $token;

    /**
     * @var string 
     * @ORM\Column(name="username", type="string", nullable=false)
     */
    protected $username;

    /**
     * @var string 
     * @ORM\Column(name="email", type="string", nullable=false)
     */
    protected $email;

    /**
     *
     * @var array
     * @ORM\Column(name="roles", type="array", nullable=false)
     */
    protected $roles;

    /**
     *
     * @var array 
     * @ORM\Column(name="divisions", type="array", nullable=false)
     */
    protected $divisions;

    /**
     * @var DateTime 
     * @ORM\Column(name="date_created", type="datetime", nullable=true)
     */
    protected $dateCreated;

    /**
     * @var DateTime 
     * @ORM\Column(name="date_updated", type="datetime", nullable=true)
     */
    protected $dateUpdated;

    /**
     * 
     * @param string $accountUuid
     * @param string $ownerUuid
     * @param string $token
     * @param string $username
     * @param string $email
     * @param array $roles
     * @param array $divisions
     */
    public function __construct($accountUuid, $ownerUuid, $token, $username, $email, array $roles, array $divisions)
    {
        $this->accountUuid = $accountUuid;
        $this->ownerUuid = $ownerUuid;
        $this->token = $token;
        $this->username = $username;
        $this->email = $email;
        $this->roles = $roles;
        $this->divisions = $divisions;
        $this->dateCreated = new DateTime();
        $this->dateUpdated = new DateTime();
    }

    /**
     * @see \IssetBV\MijnIssetAuthBundle\Model\User::getId()
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @see \IssetBV\MijnIssetAuthBundle\Model\User::getToken()
     */
    public function getToken()
    {
        return $this->token;
    }

    /**
     * @see \IssetBV\MijnIssetAuthBundle\Model\User::getRoles()
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * @see \IssetBV\MijnIssetAuthBundle\Model\User::getUsername()
     */
    public function getUsername()
    {
        return $this->username;
    }

    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }

    public function setRoles(array $roles)
    {
        $this->roles = $roles;
        return $this;
    }

    public function getDivisions()
    {
        return $this->divisions;
    }

    public function setDivisions(array $divisions)
    {
        $this->divisions = $divisions;
        return $this;
    }

    public function getAccountUuid()
    {
        return $this->accountUuid;
    }

    public function getOwnerUuid()
    {
        return $this->ownerUuid;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function getDateCreated()
    {
        return $this->dateCreated;
    }

    public function getDateUpdated()
    {
        return $this->dateUpdated;
    }
}
