<?php

namespace IssetBV\MijnIssetAuthBundle\Controller;

use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Response;

/**
 * Class RemoteController
 * @package IssetBV\MijnIssetAuthBundle\Controller
 * @author Bart Malestein <bart@isset.nl>
 */
class RemoteController extends Controller{

    /**
     * @return Response
     */
    public function indexAction(){

        /** @var Client $client */
        $client = $this->get('isset_bv_mijn_isset_auth.client');
        $token = $this->getUser()->getEntity()->getToken();

        $response = $client->getRemotes($token);
        $remotes = $response->getBody(true);

        return $this->render($this->container->getParameter('isset_bv_mijn_isset_auth.remotes.index'), ['remotes' => $remotes]);
    }

    /**
     * @param $id
     * @return \Symfony\Component\HttpFoundation\RedirectResponse
     */
    public function deleteAction($id){
        /** @var Client $client */
        $client = $this->get('isset_bv_mijn_isset_auth.client');
        $token = $this->getUser()->getEntity()->getToken();
        $response = $client->deleteRemote($token, $id);

        if($response->getStatusCode() === Response::HTTP_OK){
            $this->get('session')->getFlashBag()->add('notice', 'Remote removed');
        }else{
            $this->get('session')->getFlashBag()->add('danger', 'Failed to remove remote');
        }

        return $this->redirect($this->generateUrl('isset_bv_mijn_isset_auth_remotes_index'));

    }

}