<?php
namespace IssetBV\MijnIssetAuthBundle\Command;

use IssetBV\MijnIssetAuthBundle\Response\GuzzleResponse;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class TestCommand
 * @package IssetBV\MijnIssetAuthBundle\Command
 * @author Bart Malestein <bart@isset.nl>
 */
class TestCommand extends ContainerAwareCommand
{
    /**
     *
     */
    protected function configure()
    {
        $this->setName('issetbv:mijnisset:test');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|null|void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $data[] = array('type' => 'image', 'sub_type' => 'png', 'size' => 10000);

        /** @var GuzzleResponse $response */
        $response = $this->getContainer()->get('isset_bv_mijn_isset_auth.client')->sendPayments('4696ec72b8d60d842c3d37e60cf4c7f075edd7fd', $data);

        foreach ($response->getBody() as $key => $row) {
            $output->writeln(sprintf('[%s]: %s', $key, $row));
        }
    }
}

