<?php
namespace IssetBV\MijnIssetAuthBundle\Security\Event;

use Symfony\Component\EventDispatcher\Event;
use IssetBV\MijnIssetAuthBundle\Security\OAuthUser;

/**
 * Class LoadUserEvent
 * @package IssetBV\MijnIssetAuthBundle\Security\Event
 * @author <felix@isset.nl>
 */
class LoadUserEvent extends Event
{

    /**
     *
     */
    const EVENT = 'oauth.load.user';

    /**
     *
     * @var OAuthUser
     */
    private $oAuthUser;

    /**
     * @param OAuthUser $oAuthUser
     */
    public function __construct(OAuthUser $oAuthUser)
    {
        $this->oAuthUser = $oAuthUser;
    }

    /**
     *
     * @return OAuthUser
     */
    public function getOAuthUser()
    {
        return $this->oAuthUser;
    }
}
