<?php
namespace IssetBV\MijnIssetAuthBundle\Security;

use IssetBV\MijnIssetAuthBundle\Model\User;
use \Serializable;
use Symfony\Component\Security\Core\User\UserInterface;

/**
 * Class OAuthUser
 * @package IssetBV\MijnIssetAuthBundle\Security
 * @author <felix@isset.nl>
 */
class OAuthUser implements UserInterface, Serializable
{

    /**
     * @var User
     */
    private $entity;

    /**
     * @var
     */
    private $entityId;

    /**
     * @var array
     */
    private $data = array();

    private $currentDivision;

    public function __construct(User $entity, $currentDivision)
    {
        $this->currentDivision = $currentDivision;
        $this->setEntity($entity);
    }

    /**
     * @param User $entity
     */
    public function setEntity(User $entity)
    {
        $this->entity = $entity;
        $this->entityId = $entity->getId();
    }

    /**
     * @return User
     */
    public function getEntity()
    {
        return $this->entity;
    }

    /**
     * @return mixed
     */
    public function getId()
    {
        return $this->entityId;
    }

    /**
     *
     */
    public function eraseCredentials()
    {
        return;
    }

    /**
     * @return null
     */
    public function getPassword()
    {
        return null;
    }

    /**
     * @return mixed
     */
    public function getRoles()
    {
        return $this->getEntity()->getRoles();
    }

    /**
     * @return null
     */
    public function getSalt()
    {
        return null;
    }

    /**
     * @return mixed
     */
    public function getUsername()
    {
        return $this->getEntity()->getUsername();
    }

    /**
     * @param $key
     * @return null
     */
    public function get($key)
    {
        if (! array_key_exists($key, $this->data)) {
            return null;
        }
        
        return $this->data[$key];
    }

    /**
     * @param $key
     * @param $data
     */
    public function add($key, $data)
    {
        $this->data[$key] = $data;
    }

    /**
     * @return string
     */
    public function serialize()
    {
        $data = array(
            $this->entityId,
            $this->currentDivision
        );
        return serialize($data);
    }

    /**
     * @param string $serialized
     */
    public function unserialize($serialized)
    {
        list ($this->entityId, $this->currentDivision) = unserialize($serialized);
    }

    public function getCurrentDivision()
    {
        return $this->currentDivision;
    }
 
}
