<?php

namespace IssetBV\MijnIssetAuthBundle\Response;

use GuzzleHttp\Message\ResponseInterface;
use stdClass;

/**
 * Class PaymentsResponse
 * @author Bart Malestein <bart@isset.nl>
 */
class PaymentsResponse
{
    private $statusCode;

    private $body;

    /**
     * @param ResponseInterface $response
     */
    public function __construct(ResponseInterface $response)
    {
        $this->statusCode = $response->getStatusCode();
        $this->body = $response->getBody()->read($response->getBody()->getSize());
    }

    /**
     * @param boolean $asArray
     * @return array|stdClass
     */
    public function getBody($asArray = true){

        return json_decode($this->body, $asArray);
    }


    /**
     * @return int statusCode
     */
    public function getStatusCode(){

        return $this->statusCode;
    }

    /**
     * @return string
     */
    public function __toString(){

        return $this->body;
    }
}