<?php
namespace IssetBV\MijnIssetAuthBundle\Service\Usage;

use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use Doctrine\Common\Persistence\ObjectManager;
use IssetBV\MijnIssetAuthBundle\Entity\UsageHatchery;
use \DateTime;

class UsageManager
{

    /**
     *
     * @var Client
     */
    private $client;

    /**
     *
     * @var ObjectManager
     */
    private $entityManager;

    public function __construct(ObjectManager $entityManager, Client $client)
    {
        $this->client = $client;
        $this->entityManager = $entityManager;
    }

    public function process($amount)
    {
        $repo = $this->entityManager->getRepository('IssetBVMijnIssetAuthBundle:Usage');
        $items = $repo->findBy(array(
            'sent' => false
        ), array(
            'created' => 'ASC'
        ), $amount);
        
        if (empty($items)) {
            return;
        }
        
        foreach ($items as $item) {
            if ($item instanceof UsageHatchery) {
                $this->handleHatchery($item);
            }
        }
        $this->entityManager->flush();
    }

    public function handleHatchery(UsageHatchery $usage)
    {
        $data = array(
            'encodingType' => $usage->getEncodingType(),
            'identifier' => $usage->getIdentifier(),
            'length' => $usage->getLength(),
            'resolutionX' => $usage->getResolutionX(),
            'resolutionY' => $usage->getResolutionY(),
            'size' => $usage->getSize()
        );
        
        $usage->setUpdated(new DateTime());
        try {
            $this->client->addUsage($usage->getUser()
                ->getToken(), $data);
        } catch (\Exception $e) {
            return;
        }
        
        $usage->setSent(true);
        $usage->setSentDate(new DateTime());
    }
}