<?php
namespace IssetBV\MijnIssetAuthBundle\Security;

use \Serializable;
use Symfony\Component\Security\Core\User\UserInterface;

class OAuthUser implements UserInterface, Serializable
{

    private $entity;

    private $entityId;

    private $data = array();

    public function setEntity($entity)
    {
        $this->entity = $entity;
        $this->entityId = $entity->getId();
    }

    public function getEntity()
    {
        return $this->entity;
    }

    public function getId()
    {
        return $this->entityId;
    }

    public function eraseCredentials()
    {
        return;
    }

    public function getPassword()
    {
        return null;
    }

    public function getRoles()
    {
        return $this->getEntity()->getRoles();
    }

    public function getSalt()
    {
        return null;
    }

    public function getUsername()
    {
        return $this->getEntity()->getUsername();
    }

    public function get($key)
    {
        if (! array_key_exists($key, $this->data)) {
            return null;
        }
        
        return $this->data[$key];
    }

    public function add($key, $data)
    {
        $this->data[$key] = $data;
    }

    public function serialize()
    {
        $data = array(
            $this->entityId
        );
        return serialize($data);
    }

    public function unserialize($serialized)
    {
        list ($this->entityId) = unserialize($serialized);
    }
}
