<?php
namespace IssetBV\MijnIssetAuthBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputArgument;

class ProcessUsageCommand extends ContainerAwareCommand
{

    protected function configure()
    {
        $this->setName('issetbv:mijnisset:usage:process')->addArgument('amount', InputArgument::OPTIONAL);
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $amount = $input->getParameterOption('amount', 100);
        set_time_limit(300);
        $callback = $this->getContainer()->get('isset_bv_mijn_isset_auth.usage_process');
        $callback->process($amount);
    }
}

