<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth;

use \GuzzleHttp\Client as HttpClient;

class Client
{

    /**
     *
     * @var \GuzzleHttp\Client
     */
    private $client;

    private $baseUrl;

    public function __construct($baseUrl)
    {
        $this->client = new HttpClient(array(
            'base_url' => $baseUrl
        ));
        $this->baseUrl = rtrim($baseUrl, '/') . '/';
    }

    public function getAccount($token)
    {
        $request = $this->client->get('api/account', array(
            'headers' => array(
                'x-mijn-isset' => $token
            )
        ));
        $data = json_decode($request->getBody());
        $data->token = $token;
        return $data;
    }

    public function getLoginToken($publicKey, $time, $hash)
    {
        $url = sprintf('api/oauth/token/login?platform=%s&time=%s&hash=%s', urlencode($publicKey), urlencode($time), urlencode($hash));
        return json_decode($this->client->get($url)->getBody())->login_token;
    }

    public function addUsage($token, array $data)
    {
        $request = $this->client->createRequest('POST', 'api/account/usage', array(
            'headers' => array(
                'x-mijn-isset' => $token
            )
        ));
        
        foreach ($data as $key => $value) {
            $request->getBody()->setField($key, $value);
        }
        $response = $this->client->send($request);
    }

    public function loginUrl($loginToken, $view, $returnUrl)
    {
        return sprintf('%soauth/login?login_token=%s&view=%s&return_url=%s', $this->baseUrl, urlencode($loginToken), urlencode($view), urlencode($returnUrl));
    }
}