<?php
namespace IssetBV\MijnIssetAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="usage_hatchery")
 */
class UsageHatchery extends Usage
{

    /**
     * @ORM\Column(name="size", type="bigint")
     */
    protected $size;

    /**
     * @ORM\Column(name="length", type="bigint")
     */
    protected $length;

    /**
     * @ORM\Column(name="resolution_x", type="integer")
     */
    protected $resolutionX;

    /**
     * @ORM\Column(name="resolution_y", type="integer")
     */
    protected $resolutionY;

    /**
     * @ORM\Column(name="encoding_type", type="string")
     */
    protected $encodingType;

    /**
     * Set size
     *
     * @param bigint $size            
     * @return UsageHatchery
     */
    public function setSize($size)
    {
        $this->size = $size;
        
        return $this;
    }

    /**
     * Get size
     *
     * @return bigint
     */
    public function getSize()
    {
        return $this->size;
    }

    /**
     * Set length
     *
     * @param bigint $length            
     * @return UsageHatchery
     */
    public function setLength($length)
    {
        $this->length = $length;
        
        return $this;
    }

    /**
     * Get length
     *
     * @return bigint
     */
    public function getLength()
    {
        return $this->length;
    }

    /**
     * Set resolutionX
     *
     * @param integer $resolutionX            
     * @return UsageHatchery
     */
    public function setResolutionX($resolutionX)
    {
        $this->resolutionX = $resolutionX;
        
        return $this;
    }

    /**
     * Get resolutionX
     *
     * @return integer
     */
    public function getResolutionX()
    {
        return $this->resolutionX;
    }

    /**
     * Set resolutionY
     *
     * @param integer $resolutionY            
     * @return UsageHatchery
     */
    public function setResolutionY($resolutionY)
    {
        $this->resolutionY = $resolutionY;
        
        return $this;
    }

    /**
     * Get resolutionY
     *
     * @return integer
     */
    public function getResolutionY()
    {
        return $this->resolutionY;
    }

    /**
     * Set encodingType
     *
     * @param string $encodingType            
     * @return UsageHatchery
     */
    public function setEncodingType($encodingType)
    {
        $this->encodingType = $encodingType;
        
        return $this;
    }

    /**
     * Get encodingType
     *
     * @return string
     */
    public function getEncodingType()
    {
        return $this->encodingType;
    }
}
