<?php
namespace IssetBV\MijnIssetAuthBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use \DateTime;

/**
 * @ORM\Entity
 * @ORM\Table(name="usages")
 * @ORM\InheritanceType("JOINED")
 * @ORM\DiscriminatorMap({ "hatchery" = "UsageHatchery" })
 */
class Usage
{

    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    protected $id;

    /**
     * @ORM\ManyToOne(targetEntity="IssetBV\MijnIssetAuthBundle\Model\User")
     * @ORM\JoinColumn(name="user_id", referencedColumnName="id", nullable=false)
     */
    protected $user;

    /**
     * @ORM\Column(name="identifier", type="string", unique=true)
     */
    protected $identifier;

    /**
     * @ORM\Column(name="sent", type="boolean", nullable=false)
     */
    protected $sent = false;

    /**
     * @ORM\Column(name="sent_date", type="datetimetz", nullable=true)
     */
    protected $sentDate;

    /**
     * @ORM\Column(name="created", type="datetimetz", nullable=true)
     */
    protected $created;

    /**
     * @ORM\Column(name="updated", type="datetimetz", nullable=true)
     */
    protected $updated;

    public function __construct()
    {
        $this->created = new DateTime();
        $this->updated = new DateTime();
        $this->setIdentifier(sprintf('%04X%04X-%04X-%04X-%04X-%04X%04X%04X', mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(16384, 20479), mt_rand(32768, 49151), mt_rand(0, 65535), mt_rand(0, 65535), mt_rand(0, 65535)));
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set created
     *
     * @param \DateTime $created            
     * @return UsageHatchery
     */
    public function setCreated($created)
    {
        $this->created = $created;
        
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated            
     * @return UsageHatchery
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        
        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    public function getSent()
    {
        return $this->sent;
    }

    public function setSent($sent)
    {
        $this->sent = $sent;
        return $this;
    }

    public function getSentDate()
    {
        return $this->sentDate;
    }

    public function setSentDate($sentDate)
    {
        $this->sentDate = $sentDate;
        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }

    public function getIdentifier()
    {
        return $this->identifier;
    }

    public function setIdentifier($identifier)
    {
        $this->identifier = $identifier;
        return $this;
    }
}