<?php
namespace IssetBV\MijnIssetAuthBundle\Entity;

use Doctrine\ORM\Mapping\MappedSuperclass;
use Doctrine\ORM\Mapping as ORM;
use \DateTime;
use IssetBV\MijnIssetAuthBundle\Model\User;

/**
 * @MappedSuperclass
 */
class OAuthUser implements User
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     *
     * @var string @ORM\Column(name="uuid", type="string", nullable=false, unique=true)
     */
    protected $uuid;

    /**
     *
     * @var string @ORM\Column(name="token", type="string", nullable=false, unique=true)
     */
    protected $token;

    /**
     *
     * @var string @ORM\Column(name="username", type="string", nullable=false)
     */
    protected $username;

    /**
     *
     * @var string @ORM\Column(name="email", type="string", nullable=false)
     */
    protected $email;

    /**
     *
     * @var string @ORM\Column(name="roles", type="array", nullable=false)
     */
    protected $roles;

    /**
     *
     * @var \DateTime @ORM\Column(name="date_created", type="datetimetz", nullable=true)
     */
    protected $dateCreated;

    /**
     *
     * @var \DateTime @ORM\Column(name="date_updated", type="datetimetz", nullable=true)
     */
    protected $dateUpdated;

    public function __construct()
    {
        $this->dateCreated = new DateTime();
        $this->dateUpdated = new DateTime();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set uuid
     *
     * @param string $uuid            
     * @return OAuthUser
     */
    public function setUuid($uuid)
    {
        $this->uuid = $uuid;
        
        return $this;
    }

    /**
     * Get uuid
     *
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }

    /**
     * Set username
     *
     * @param string $username            
     * @return OAuthUser
     */
    public function setUsername($username)
    {
        $this->username = $username;
        
        return $this;
    }

    /**
     * Get username
     *
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * Set email
     *
     * @param string $email            
     * @return OAuthUser
     */
    public function setEmail($email)
    {
        $this->email = $email;
        
        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set created
     *
     * @param \DateTime $created            
     * @return OAuthUser
     */
    public function setCreated($created)
    {
        $this->created = $created;
        
        return $this;
    }

    /**
     * Get created
     *
     * @return \DateTime
     */
    public function getCreated()
    {
        return $this->created;
    }

    /**
     * Set updated
     *
     * @param \DateTime $updated            
     * @return OAuthUser
     */
    public function setUpdated($updated)
    {
        $this->updated = $updated;
        
        return $this;
    }

    /**
     * Get updated
     *
     * @return \DateTime
     */
    public function getUpdated()
    {
        return $this->updated;
    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function setRoles($roles)
    {
        $this->roles = $roles;
        return $this;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }
}
