<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth;

use \GuzzleHttp\Client as HttpClient;

class Client
{

    /**
     *
     * @var \GuzzleHttp\Client
     */
    private $client;

    private $baseUrl;

    public function __construct($baseUrl)
    {
        $this->client = new HttpClient(array(
            'base_url' => $baseUrl
        ));
        $this->baseUrl = rtrim($baseUrl, '/') . '/';
    }

    public function getAccount($token)
    {
        $url = sprintf('account/%s', urlencode($token));
        return json_decode($this->client->get($url)->getBody());
    }

    public function getLoginToken($publicKey, $time, $hash)
    {
        $url = sprintf('token/login?platform=%s&time=%s&hash=%s', urlencode($publicKey), urlencode($time), urlencode($hash));
        return json_decode($this->client->get($url)->getBody())->login_token;
    }

    public function loginUrl($loginToken, $view, $returnUrl)
    {
        return sprintf('%slogin?login_token=%s&view=%s&return_url=%s', $this->baseUrl, urlencode($loginToken), urlencode($view), urlencode($returnUrl));
    }
}