<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth\Login;

use IssetBV\MijnIssetAuthBundle\Service\OAuth\Login\LoginTokenGenerator;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;

class Login
{

    /**
     *
     * @var \IssetBV\MijnIssetAuthBundle\Service\OAuth\Login\LoginTokenGenerator
     */
    private $tokenGenerator;

    private $client;

    private $publicKey;

    private $privateKey;

    public function __construct(LoginTokenGenerator $tokenGenerator, Client $client, $publicKey, $privateKey)
    {
        $this->tokenGenerator = $tokenGenerator;
        $this->client = $client;
        $this->publicKey = $publicKey;
        $this->privateKey = $privateKey;
    }

    public function getRedirectUrl($returnUrl)
    {
        $token = $this->tokenGenerator->generate($this->publicKey, $this->privateKey);
        return $this->client->loginUrl($token, 1, $returnUrl);
    }
}