<?php
namespace IssetBV\MijnIssetAuthBundle\Security;

use \DateTime;
use Symfony\Component\Security\Core\User\UserInterface;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use Symfony\Component\Security\Core\User\UserProviderInterface;
use IssetBV\MijnIssetAuthBundle\Security\Event\LoadUserEvent;
use Symfony\Bridge\Doctrine\RegistryInterface;
use Doctrine\Common\Persistence\ObjectManager;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;

class OAuthUserProvider implements UserProviderInterface
{

    /**
     *
     * @var RegistryInterface
     */
    private $oAuthUserRepo;

    /**
     *
     * @var ObjectManager
     */
    private $em;

    /**
     *
     * @var EventDispatcher
     */
    private $dispatcher;

    /**
     *
     * @var Client
     */
    private $client;

    /**
     *
     * @var string
     */
    private $userClass;

    public function __construct(RegistryInterface $doctrine, EventDispatcherInterface $dispatcher, Client $client, $userClass)
    {
        if ($userClass == null || $userClass == '') {
            throw new \Exception('No user class given');
        }
        
        $this->client = $client;
        $this->oAuthUserRepo = $doctrine->getRepository($userClass);
        $this->em = $doctrine->getManager();
        $this->userClass = $userClass;
        $this->dispatcher = $dispatcher;
    }

    public function getUsernameForApiKey($token)
    {
        return $this->client->getAccount($token);
    }

    public function loadUserByUsername($data)
    {
        $oAuthUser = $this->oAuthUserRepo->findOneBy(array(
            'uuid' => $data->UUID
        ));
        
        if ($oAuthUser == null) {
            $userClass = $this->userClass;
            $oAuthUser = new $userClass();
            $oAuthUser->setUuid($data->UUID);
            $oAuthUser->setUsername($data->username);
            $oAuthUser->setEmail($data->email);
            $oAuthUser->setCreated(new DateTime());
            $this->em->persist($oAuthUser);
            $this->em->flush();
        }
        
        $user = new OAuthUser($data);
        $user->setEntity($oAuthUser);
        
        $this->dispatcher->dispatch(LoadUserEvent::EVENT, new LoadUserEvent($user));
        return $user;
    }

    public function refreshUser(UserInterface $user)
    {
        $oAuthUser = $this->oAuthUserRepo->find($user->getId());
        $user->setEntity($oAuthUser);
        return $user;
    }

    public function supportsClass($class)
    {
        return $class === 'IssetBV\MijnIssetAuthBundle\Security\OAuthUser';
    }
}