<?php
namespace IssetBV\MijnIssetAuthBundle\Service\OAuth\Login;

use Symfony\Component\Security\Core\Encoder\EncoderFactoryInterface;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;

class LoginTokenGenerator
{

    /**
     *
     * @var \Symfony\Component\Security\Core\Encoder\PasswordEncoderInterface
     */
    private $encoder;

    /**
     *
     * @var \IssetBV\MijnIssetAuthBundle\Service\OAuth\Client
     */
    private $client;

    public function __construct(EncoderFactoryInterface $encoderFactory, Client $client)
    {
        $this->encoder = $encoderFactory->getEncoder($this);
        $this->client = $client;
    }

    public function generate($publicKey, $privateKey)
    {
        $time = time() . '_' . sha1(mt_rand(0, mt_getrandmax()) . microtime() . uniqid('_', true));
        $hash = $this->encoder->encodePassword($time . $publicKey . $privateKey, $time);
        return $this->client->getLoginToken($publicKey, $time, $hash);
    }
}