<?php

namespace IssetBV\MijnIssetAuthBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class LoginController extends Controller
{

    public function loginAction()
    {
        $returnUrl   = $this->generateUrl('isset_bv_mijn_isset_auth_callback', array(), UrlGeneratorInterface::ABSOLUTE_URL);
        $redirectUrl = $this->get('isset_bv_mijn_isset_auth.login')->getRedirectUrl($returnUrl);
        return $this->redirect($redirectUrl);
    }

    public function callbackAction()
    {

        if ($this->getRequest()->query->get('message', '') == 'success') {
            $route = $this->container->getParameter('isset_bv_mijn_isset_auth.route_success');
        } else {
            $route = $this->container->getParameter('isset_bv_mijn_isset_auth.route_failed');
        }



        return $this->redirect($this->generateUrl($route));
    }

}
