<?php
namespace IssetBV\MijnIssetAuthBundle\Security;

use Symfony\Component\Security\Core\User\UserInterface;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use \DateTime;
use Symfony\Component\Security\Core\User\UserProviderInterface;

class OAuthUserProvider implements UserProviderInterface
{

    private $client;

    private $oAuthUserRepo;

    private $em;

    private $userClass;

    public function __construct($doctrine, Client $client, $userClass)
    {
        $this->client = $client;
        
        $this->oAuthUserRepo = $doctrine->getRepository($userClass);
        $this->em = $doctrine->getManager();
        $this->userClass = $userClass;
    }

    public function getUsernameForApiKey($token)
    {
        return $this->client->getAccount($token);
    }

    public function loadUserByUsername($data)
    {
        $oAuthUser = $this->oAuthUserRepo->findOneBy(array(
            'uuid' => $data->UUID
        ));
        
        if ($oAuthUser == null) {
            $userClass = $this->userClass;
            $oAuthUser = new $userClass();
            $oAuthUser->setUuid($data->UUID);
            $oAuthUser->setUsername($data->username);
            $oAuthUser->setEmail($data->email);
            $oAuthUser->setCreated(new DateTime());
            $this->em->persist($oAuthUser);
            $this->em->flush();
        }
        
        $user = new OAuthUser($data);
        $user->setEntity($oAuthUser);
        return $user;
    }

    public function refreshUser(UserInterface $user)
    {
        $oAuthUser = $this->oAuthUserRepo->find($user->getId());
        $user->setEntity($oAuthUser);
        return $user;
    }

    public function supportsClass($class)
    {
        return $class === 'IssetBV\MijnIssetAuthBundle\Security\OAuthUser';
    }
}