<?php
namespace IssetBV\MijnIssetAuthBundle\Security;

use Symfony\Component\Security\Core\User\UserInterface;
use IssetBV\MijnIssetAuthBundle\Service\OAuth\Client;
use IssetBV\MijnIssetAuthBundle\Entity\OAuthUser as OAuthUserEntity;
use \DateTime;

class OAuthUserProvider implements \Symfony\Component\Security\Core\User\UserProviderInterface
{

    private $client;

    private $oAuthUserRepo;

    private $em;

    public function __construct($doctrine, Client $client)
    {
        $this->client = $client;
        $this->oAuthUserRepo = $doctrine->getRepository('IssetBVMijnIssetAuthBundle:OAuthUser');
        $this->em = $doctrine->getManager();
    }

    public function getUsernameForApiKey($token)
    {
        return $this->client->getAccount($token);
    }

    public function loadUserByUsername($data)
    {
        $oAuthUser = $this->oAuthUserRepo->findOneBy(array(
            'uuid' => $data->UUID
        ));
        
        if ($oAuthUser == null) {
            $oAuthUser = new OAuthUserEntity();
            $oAuthUser->setUuid($data->UUID);
            $oAuthUser->setUsername($data->username);
            $oAuthUser->setEmail($data->email);
            $oAuthUser->setCreated(new DateTime());
            $this->em->persist($oAuthUser);
            $this->em->flush();
        }
        
        $user = new OAuthUser($data);
        $user->setEntity($oAuthUser);
        return $user;
    }

    public function refreshUser(UserInterface $user)
    {
        $oAuthUser = $this->oAuthUserRepo->find($user->getId());
        $user->setEntity($oAuthUser);
        return $user;
    }

    public function supportsClass($class)
    {
        return $class === 'IssetBV\MijnIssetAuthBundle\Security\OAuthUser';
    }
}