<?php

namespace IssetBV\MijnIssetAuthBundle\Security;

use Symfony\Component\Security\Core\User\UserInterface;

class OAuthUser implements UserInterface, \Serializable
{

    private $username;
    private $email;
    private $roles;
    private $entity;
    private $entityId;

    public function __construct($data)
    {
        $this->username = $data->username;
        $this->email    = $data->email;
        $this->roles    = $data->roles;
    }

    public function setEntity($entity)
    {
        $this->entity   = $entity;
        $this->entityId = $entity->getId();
    }

    public function getEntity()
    {
        return $this->entity;
    }

    public function getId()
    {
        return $this->entityId;
    }

    public function eraseCredentials()
    {

    }

    public function getPassword()
    {

    }

    public function getRoles()
    {
        return $this->roles;
    }

    public function getSalt()
    {
        
    }

    public function getUsername()
    {
        return $this->username;
    }

    public function serialize()
    {
        $data = array($this->email, $this->roles, $this->username, $this->entityId);
        return serialize($data);
    }

    public function unserialize($serialized)
    {
        list($this->email, $this->roles, $this->username, $this->entityId) = unserialize($serialized);
    }

}
