<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Compiler;

use IssetBV\Message\MessageBundle\DependencyInjection\IssetBVMessageMessageExtension;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class MessageBundleCompilerPass implements CompilerPassInterface
{
    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $this->buildEncoders($container);
        $this->buildDecoders($container);
        $this->buildHandlers($container);
    }

    private function buildEncoders(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVMessageMessageExtension::ENCODER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds('nl.isset.message.encoder');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }

    private function buildDecoders(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVMessageMessageExtension::DECODER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds('nl.isset.message.decoder');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }

    private function buildHandlers(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(IssetBVMessageMessageExtension::HANDLER_CONTAINER_DEFAULT);
        $taggedServices = $container->findTaggedServiceIds('nl.isset.message.handler');
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }
}
