<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Command;

use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

class MessageConsumerCommand extends ContainerAwareCommand
{
    protected function configure()
    {
        $this
            ->setName('issetbv:message:dequeue')
            ->addArgument('consumer', InputArgument::REQUIRED)
            ->setDescription('Throws the given event');
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->getContainer()->get('nl.isset.message.dequeuer.' . $input->getArgument('consumer'))->dequeue();
    }
}
