<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Service\AMQP;

use IssetBV\Message\Core\Queue\ConnectionInterface;
use IssetBV\Message\Core\Queue\QueueInterface;
use PhpAmqpLib\Channel\AMQPChannel;
use PhpAmqpLib\Connection\AMQPStreamConnection;

class AMQPConnection implements ConnectionInterface
{
    /**
     * @var AMQPConnectionOptions
     */
    private $options;
    /**
     * @var AMQPStreamConnection|null
     */
    private $connection = null;

    public function __construct(AMQPConnectionOptions $options)
    {
        $this->options = $options;
    }

    /**
     * @param int|null $channelId
     *
     * @return AMQPChannel
     */
    public function getChannel(int $channelId = null): AMQPChannel
    {
        return $this->getConnection()->channel($channelId);
    }

    public function getConnection(): AMQPStreamConnection
    {
        if (null === $this->connection) {
            $this->connection = new AMQPStreamConnection(
                $this->options->getHost(),
                $this->options->getPort(),
                $this->options->getUser(),
                $this->options->getPassword(),
                $this->options->getVhost(),
                $this->options->isInsist(),
                $this->options->getLoginMethod(),
                $this->options->getLoginResponse(),
                $this->options->getLocale(),
                $this->options->getConnectionTimeout(),
                $this->options->getReadWriteTimeout(),
                $this->options->getContext(),
                $this->options->isKeepalive(),
                $this->options->getHeartbeat()
            );
        }

        return $this->connection;
    }

    public function close()
    {
        if (null === $this->connection) {
            return;
        }
        $this->connection->close();
        $this->connection = null;
    }

    public function getQueue(string $exchange, string $queue, array $options = []): QueueInterface
    {
        return new AMQPQueue($this, $exchange, $queue, $options);
    }
}
