<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Service\AMQP;

use IssetBV\Message\Core\Connection\ConnectionMessageInterface;
use PhpAmqpLib\Channel\AMQPChannel;
use PhpAmqpLib\Message\AMQPMessage as PhpAMPQMessage;

class AMQPMessage implements ConnectionMessageInterface
{
    /**
     * @var PhpAMPQMessage
     */
    private $message;
    /**
     * @var AMQPChannel
     */
    private $channel;

    public function __construct(AMQPChannel $channel, PhpAMPQMessage $message)
    {
        $this->message = $message;
        $this->channel = $channel;
    }

    public function getBody(): string
    {
        return $this->message->getBody();
        // TODO: Implement getBody() method.
    }

    public function ack()
    {
        $this->channel->basic_ack($this->message->delivery_info['delivery_tag']);
    }

    public function reject()
    {
        $this->channel->basic_reject($this->message->delivery_info['delivery_tag'], false);
    }
}
