<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Service\AMQP;

class AMQPConnectionOptions
{
    /**
     * @var string
     */
    private $host;
    /**
     * @var string
     */
    private $port;
    /**
     * @var string
     */
    private $user;
    /**
     * @var string
     */
    private $password;
    /**
     * @var string
     */
    private $vhost;
    /**
     * @var bool
     */
    private $insist;
    /**
     * @var string
     */
    private $login_method;
    /**
     * @var null
     */
    private $login_response;
    /**
     * @var string
     */
    private $locale;
    /**
     * @var float
     */
    private $connection_timeout;
    /**
     * @var float
     */
    private $read_write_timeout;
    /**
     * @var null
     */
    private $context;
    /**
     * @var bool
     */
    private $keepalive;
    /**
     * @var int
     */
    private $heartbeat;
    /**
     * @var string
     */
    private $name;

    public function __construct(
        string $name,
        string $host,
        string $port,
        string $user,
        string $password,
        string $vhost = '/',
        bool $insist = false,
        string $login_method = 'AMQPLAIN',
        string $login_response = null,
        string $locale = 'en_US',
        float $connection_timeout = 3.0,
        float $read_write_timeout = 3.0,
        string $context = null,
        bool $keepalive = false,
        int $heartbeat = 0
    ) {
        $this->host = $host;
        $this->port = $port;
        $this->user = $user;
        $this->password = $password;
        $this->vhost = $vhost;
        $this->insist = $insist;
        $this->login_method = $login_method;
        $this->login_response = $login_response;
        $this->locale = $locale;
        $this->connection_timeout = $connection_timeout;
        $this->read_write_timeout = $read_write_timeout;
        $this->context = $context;
        $this->keepalive = $keepalive;
        $this->heartbeat = $heartbeat;
        $this->name = $name;
    }

    /**
     * @return mixed
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return mixed
     */
    public function getPort()
    {
        return $this->port;
    }

    /**
     * @return mixed
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @return mixed
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getVhost(): string
    {
        return $this->vhost;
    }

    /**
     * @return bool
     */
    public function isInsist(): bool
    {
        return $this->insist;
    }

    /**
     * @return string
     */
    public function getLoginMethod(): string
    {
        return $this->login_method;
    }

    public function getLoginResponse()
    {
        return $this->login_response;
    }

    /**
     * @return string
     */
    public function getLocale(): string
    {
        return $this->locale;
    }

    /**
     * @return float
     */
    public function getConnectionTimeout(): float
    {
        return $this->connection_timeout;
    }

    /**
     * @return float
     */
    public function getReadWriteTimeout(): float
    {
        return $this->read_write_timeout;
    }

    public function getContext()
    {
        return $this->context;
    }

    /**
     * @return bool
     */
    public function isKeepalive(): bool
    {
        return $this->keepalive;
    }

    /**
     * @return int
     */
    public function getHeartbeat(): int
    {
        return $this->heartbeat;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }
}
