<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Compiler;

use IssetBV\Message\Core\Connection\ConnectionFactory;
use IssetBV\Message\Core\MessageConsumerContainerInterface;
use IssetBV\Message\Core\MessagePublisherInterface;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class MessageBundleCompilerPass implements CompilerPassInterface
{
    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $this->buildConnectionFactory($container);
        $this->buildMessagePublisher($container);
        $this->buildMessageConsumer($container);
        $this->buildMessageEncoders($container);
    }

    /**
     * @param ContainerBuilder $container
     *
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     */
    private function buildConnectionFactory(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(ConnectionFactory::class);
        $taggedServices = $container->findTaggedServiceIds(ConnectionFactory::TAG);
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', [
                new Reference($id),
            ]);
        }
    }

    private function buildMessagePublisher(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(MessagePublisherInterface::class);
        $taggedServices = $container->findTaggedServiceIds('isset_bv_message_message.publisher_handler');
        foreach (array_keys($taggedServices) as $taggedId) {
            $definition->addMethodCall('add', [
                new Reference($taggedId),
            ]);
        }
    }

    private function buildMessageConsumer(ContainerBuilder $container)
    {
        $definition = $container->findDefinition(MessageConsumerContainerInterface::class);
        $taggedServices = $container->findTaggedServiceIds('isset_bv_message_message.consumer_handler');
        foreach (array_keys($taggedServices) as $taggedId) {
            $definition->addMethodCall('add', [
                new Reference($taggedId),
            ]);
        }
    }

    private function buildMessageEncoders(ContainerBuilder $container)
    {
        $taggedServices = $container->findTaggedServiceIds('isset_bv_message_message.publisher_handler');
        $encoders = $container->findTaggedServiceIds('isset_bv_message_message.encoder');
        foreach (array_keys($encoders) as $taggedId) {
            foreach (array_keys($taggedServices) as $handlerId) {
                $definition = $container->findDefinition($handlerId);
                $definition->addMethodCall('add', [
                    new Reference($taggedId),
                ]);
            }
        }
    }
}
