<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Compiler;

use IssetBV\Message\Core\Connection\ConnectionFactory;
use IssetBV\Message\Core\MessageConsumerContainerInterface;
use IssetBV\Message\Core\MessagePublisher;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Reference;

class MessageBundleCompilerPass implements CompilerPassInterface
{

    /**
     * You can modify the container here before it is dumped to PHP code.
     *
     * @param ContainerBuilder $container
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     */
    public function process(ContainerBuilder $container)
    {
        $this->buildConnectionFactory($container);
        $this->buildMessagePublisher($container);
        $this->buildMessageConsumer($container);
    }

    /**
     * @param ContainerBuilder $container
     * @throws \Symfony\Component\DependencyInjection\Exception\InvalidArgumentException
     * @throws \Symfony\Component\DependencyInjection\Exception\ServiceNotFoundException
     */
    private function buildConnectionFactory(ContainerBuilder $container)
    {
        $tag = ConnectionFactory::class;
        if (!$container->hasDefinition($tag)) {
            return;
        }
        $definition = $container->getDefinition($tag);
        $taggedServices = $container->findTaggedServiceIds(ConnectionFactory::TAG);
        foreach (array_keys($taggedServices) as $id) {
            $definition->addMethodCall('add', array(
                new Reference($id)
            ));
        }
    }

    private function buildMessagePublisher(ContainerBuilder $container)
    {
        $id = MessagePublisher::class;
        if (!$container->hasDefinition($id)) {
            return;
        }
        $definition = $container->getDefinition($id);
        $taggedServices = $container->findTaggedServiceIds('isset_bv_message_message.publisher_handler');
        foreach (array_keys($taggedServices) as $taggedId) {
            $definition->addMethodCall('add', array(
                new Reference($taggedId)
            ));
        }
    }

    private function buildMessageConsumer(ContainerBuilder $container)
    {
        $id = 'isset_bv_message_message.consumer.container';
        if (!$container->hasDefinition($id)) {
            return;
        }
        $definition = $container->getDefinition($id);
        $taggedServices = $container->findTaggedServiceIds('isset_bv_message_message.consumer_handler');
        foreach (array_keys($taggedServices) as $taggedId) {
            $definition->addMethodCall('add', array(
                new Reference($taggedId)
            ));
        }
    }

}
