<?php

declare(strict_types=1);

namespace IssetBV\Message\MessageBundle\Service\AMQP;

use IssetBV\Message\Core\Connection\QueueInterface;
use PhpAmqpLib\Channel\AMQPChannel;
use PhpAmqpLib\Message\AMQPMessage as PhpAMPQMessage;

class AMQPPQueue implements QueueInterface
{

    /**
     * @var AMQPChannel
     */
    private $channel;
    /**
     * @var string
     */
    private $exchange;
    /**
     * @var string
     */
    private $queue;

    public function __construct(AMQPChannel $channel, string $exchange, string $queue)
    {
        $this->channel = $channel;
        $this->exchange = $exchange;
        $this->queue = $queue;
    }

    public function send(string $message)
    {
        $this->channel->basic_publish(new PhpAMPQMessage($message), $this->exchange);
    }

    public function receive()
    {
        $message = $this->channel->basic_get($this->queue);
        /* @var PhpAMPQMessage $message */
        if ($message === null) {
            return null;
        }
        return new AMQPMessage(  $this->channel, $message);
    }
}