<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Queuer;

use IssetBV\Message\Core\Message\Encoder\EncoderContainerInterface;
use IssetBV\Message\Core\Message\MessageInterface;
use IssetBV\Message\Core\Queue\QueueInterface;

class Queuer implements QueuerInterface
{
    /**
     * @var EncoderContainerInterface
     */
    private $encoderContainer;
    /**
     * @var QueueInterface
     */
    private $queue;

    public function __construct(EncoderContainerInterface $encoderContainer, QueueInterface $queue)
    {
        $this->encoderContainer = $encoderContainer;
        $this->queue = $queue;
    }

    public function queue(MessageInterface $message)
    {
        $messageString = $this->encoderContainer->encode($message);

        $headers = array_merge($message->getHeaders(), [
            MessageInterface::HEADER_VERSION => $message->getVersion(),
            MessageInterface::HEADER_TYPE => $message->getType(),
        ]);

        $this->queue->send($messageString, $headers);
    }
}
