<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Handler;

use IssetBV\Message\Core\Message\Handler\Exception\HandlerNotFoundException;
use IssetBV\Message\Core\Message\MessageInterface;

interface HandlerContainerInterface
{
    /**
     * @param MessageInterface $message
     *
     * @throws HandlerNotFoundException
     *
     * @return HandlerInterface
     */
    public function get(MessageInterface $message): HandlerInterface;

    public function add(HandlerInterface $decoder);

    /**
     * @param MessageInterface $message
     *
     * @throws HandlerNotFoundException
     *
     * @return ResponseInterface
     */
    public function handle(MessageInterface $message): ResponseInterface;
}
