<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Queue;

class QueueProxy implements QueueInterface
{
    /**
     * @var QueueInterface
     */
    private $queue;

    public function __construct(ConnectionInterface $connection, string $exchange, string $queue, array $options = [])
    {
        $this->queue = $connection->getQueue($exchange, $queue, $options);
    }

    /**
     * @param QueueMessageInterface $connectionMessage
     */
    public function ack(QueueMessageInterface $connectionMessage)
    {
        $this->queue->ack($connectionMessage);
    }

    /**
     * @param QueueMessageInterface $connectionMessage
     * @param bool $requeue
     */
    public function reject(QueueMessageInterface $connectionMessage, bool $requeue = false)
    {
        $this->queue->reject($connectionMessage, $requeue);
    }

    /**
     * @param string $message
     * @param array $headers
     */
    public function send(string $message, array $headers = [])
    {
        $this->queue->send($message, $headers);
    }

    /**
     * @param int $wait
     *
     * @return QueueMessageInterface|null
     */
    public function receive(int $wait = 0)
    {
        return $this->queue->receive($wait);
    }
}
