<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Handler;

class Response implements ResponseInterface
{
    /**
     * @var bool
     */
    private $success;
    /**
     * @var bool
     */
    private $requeue;

    public function __construct(bool $success, bool $requeue = false)
    {
        $this->success = $success;
        $this->requeue = $requeue;
    }

    public function isSuccess(): bool
    {
        return $this->success;
    }

    public function requeue(): bool
    {
        return $this->requeue;
    }
}
