<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Handler;

use IssetBV\Message\Core\Message\Handler\Exception\HandlerNotFoundException;
use IssetBV\Message\Core\Message\MessageInterface;

class HandlerContainer implements HandlerContainerInterface
{
    /**
     * @var HandlerInterface[]
     */
    private $handlers = [];

    public function get(MessageInterface $message): HandlerInterface
    {
        foreach ($this->handlers as $handler) {
            if ($handler::handles($message)) {
                return $handler;
            }
        }

        throw new HandlerNotFoundException('No handler found for type: ' . $message->getType() . ' version: ' . $message->getType() . ' class: ' . get_class($message));
    }

    public function add(HandlerInterface $decoder)
    {
        $this->handlers[] = $decoder;
    }

    public function handle(MessageInterface $message): ResponseInterface
    {
        return $this->get($message)->handle($message);
    }
}
