<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Encoder;

use IssetBV\Message\Core\Message\Encoder\Exception\EncoderNotFoundException;
use IssetBV\Message\Core\Message\MessageInterface;

class EncoderContainer implements EncoderContainerInterface
{
    /**
     * @var EncoderInterface[]
     */
    private $encoders = [];

    public function get(MessageInterface $message): EncoderInterface
    {
        foreach ($this->encoders as $encoder) {
            if ($encoder::encodes($message)) {
                return $encoder;
            }
        }

        throw new EncoderNotFoundException('No encoder found for type: ' . $message->getType() . ' version: ' . $message->getVersion() . ' class: ' . get_class($message));
    }

    public function add(EncoderInterface $encoder)
    {
        $this->encoders[] = $encoder;
    }

    public function encode(MessageInterface $message): string
    {
        return $this->get($message)->encode($message);
    }
}
