<?php

declare(strict_types=1);

namespace IssetBV\Message\Core\Message\Dequeuer;

class Stats implements StatsInterface
{
    /**
     * @var bool
     */
    private $receivedMessage;

    private $startTime;
    private $stopTime;

    public function startTimer()
    {
        $this->startTime = time();
    }

    public function stopTimer()
    {
        $this->stopTime = time();
    }

    public function waitTime(): int
    {
        if (null === $this->startTime) {
            throw new \LogicException('DequeuerStats Timer not started');
        }

        if (null === $this->stopTime) {
            throw new \LogicException('DequeuerStats Timer not stopped');
        }

        return $this->stopTime - $this->startTime;
        // TODO: Implement waitTime() method.
    }

    /**
     * @return bool
     */
    public function hasReceivedMessage(): bool
    {
        return $this->receivedMessage;
    }

    /**
     * @param bool $receivedMessage
     */
    public function setReceivedMessage(bool $receivedMessage)
    {
        $this->receivedMessage = $receivedMessage;
    }
}
